-- MacroScript File
-- Created:       Feb 09 2005
-- Last Modified: Feb 25 2005
-- Medit Utilities
-- Version: 3dsmax 8
-- Author: Alexander Esppeschit Bicalho, Discreet
-- Modified: Alexander Esppeschit Bicalho, Discreet
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Feb 09 - created script
Feb 10 - fixed problem where defaults.ini uses Hex number and ClassID is an Int
Feb 10 - added Restore Medit Slots script
Feb 11 - added Localization Notes
Feb 25 - added Condense Medit
Feb 25 - moved functions to meditfunctions.ms in StdScripts

NOTE TO LOCALIZATION
Only the headers should be localized

*/

macroScript clear_medit_slots 
	category:~CLEAR_MEDIT_SLOTS_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~CLEAR_MEDIT_SLOTS_BUTTONTEXT~ 
	tooltip:~CLEAR_MEDIT_SLOTS_TOOLTIP~
(


on execute do
(
	defaultMtlLibFile = MeditUtilities.getDefaultLibraryFile()
	if defaultMtlLibFile != undefined do
	(
		defaultMtlLib = loadTempMaterialLibrary defaultMtlLibFile
		global _meditMaterialsBeforeReset = #()
		for i in 1 to meditMaterials.count do
		(	
			append _meditMaterialsBeforeReset meditMaterials[i]
			if i <= defaultMtlLib.count then
				meditMaterials[i] = defaultMtlLib[i]
			else
				meditMaterials[i] = defaultMtlLib[defaultMtlLib.count]
		)
	)
)

)

macroScript restore_medit_slots 
	category:~RESTORE_MEDIT_SLOTS_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~RESTORE_MEDIT_SLOTS_BUTTONTEXT~ 
	tooltip:~RESTORE_MEDIT_SLOTS_TOOLTIP~
(

on isEnabled do (classof _meditMaterialsBeforeReset == Array and _meditMaterialsBeforeReset.count > 0)

on execute do
(
	if _meditMaterialsBeforeReset.count == meditMaterials.count do
	(
		for i in 1 to meditMaterials.count do
		(	
			meditMaterials[i] = _meditMaterialsBeforeReset[i]
		)
		_meditMaterialsBeforeReset = undefined
	)
)

)

macroScript condense_medit_slots 
	category:~CONDENSE_MEDIT_SLOTS_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~CONDENSE_MEDIT_SLOTS_BUTTONTEXT~ 
	tooltip:~CONDENSE_MEDIT_SLOTS_TOOLTIP~
(


on execute do
(
	defaultMtlLibFile = MeditUtilities.getDefaultLibraryFile()
	if defaultMtlLibFile != undefined do
	(
		defaultMtlLib = loadTempMaterialLibrary defaultMtlLibFile

		usedMtls = #()
		for i in 1 to meditMaterials.count do
		(
			if MeditUtilities.isMaterialInUse meditMaterials[i] == true do
				append usedMtls meditMaterials[i]
		)
		global _meditMaterialsBeforeReset = #()
		for i in 1 to meditMaterials.count do
		(	
			append _meditMaterialsBeforeReset meditMaterials[i]
			if i <= usedMtls.count then
				meditMaterials[i] = usedMtls[i]
			else if i <= defaultMtlLib.count then
				meditMaterials[i] = defaultMtlLib[i]
			else
				meditMaterials[i] = defaultMtlLib[defaultMtlLib.count]
		)
	)
)

)

macroScript basic_material_editor
	category:~BASIC_MATERIAL_EDITOR_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~BASIC_MATERIAL_EDITOR_BUTTONTEXT~ 
	tooltip:~BASIC_MATERIAL_EDITOR_TOOLTIP~
(
	on isChecked do
	(
		MatEditor.isOpen() and MatEditor.mode == #basic
	)

	on execute do
	(
		if MatEditor.isOpen() then
		(
			if MatEditor.mode == #advanced then (
				-- this switches the open slate editor into the compact editor
				MatEditor.mode = #basic
			)
			else (
				-- toggle the compact editor
				matEditor.Close()
			)
		)
		else (
			MatEditor.mode = #basic
			matEditor.Open()
		)
	)
)

macroScript advanced_material_editor
	category:~ADVANCED_MATERIAL_EDITOR_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~ADVANCED_MATERIAL_EDITOR_BUTTONTEXT~ 
	tooltip:~ADVANCED_MATERIAL_EDITOR_TOOLTIP~
(

	on isChecked do
	(
		sme.isOpen()
	)

	on execute do
	(
		if MatEditor.isOpen() then
		(
			if MatEditor.mode == #basic then (
				-- this switches the open compact editor into the slate editor
				MatEditor.mode = #advanced
			)
			else (
				-- toggle the slate editor
				sme.Close()
			)
		)
		else (
			MatEditor.mode = #advanced
			sme.Open()
		)
	)
)


macroScript material_create_new_sme
	category:~MATERIAL_CREATE_NEW_SME_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~MATERIAL_CREATE_NEW_SME_BUTTONTEXT~
	tooltip:~MATERIAL_CREATE_NEW_SME_TOOLTIP~
(
	on execute do
	(
		-- TO DO: Is this obsolete?  See stdplugs\stdscripts\meditfunctions.ms
		local newMtl = meditUtilities.getDefaultMaterial undefined

		-- Close Medit
		maxOps.mtlDlgMode = #advanced  -- closes Medit if open and switches to SME

		-- Open SME, or restore the window if minimized
		sme.Open() -- checking sme.IsOpen() is not reliable, it returns true if window is minimized
		
		local nodeViewIndex = sme.activeView
		local nodeView = sme.getView nodeViewIndex
		local nodePos = [0,0]
		nodeView.CreateNode newMtl nodePos
		nodeView.setSelectedNodes #(newMtl)
		nodeView.zoomExtents type:#selected

		sme.SetMtlInParamEditor newMtl
	)
)


macroScript material_edit_selected_sme
	category:~MATERIAL_EDIT_SELECTED_SME_CATEGORY~ 
	internalCategory:"Medit Tools"
	ButtonText:~MATERIAL_EDIT_SELECTED_SME_BUTTONTEXT~
	tooltip:~MATERIAL_EDIT_SELECTED_SME_TOOLTIP~
(
	on isEnabled do (selection.count==1)

	on execute do
	(
		local editMtl = $.material  -- assume exactly one selected object
		
		if editMtl==undefined do
		(	-- TO DO: Is this obsolete?  See stdplugs\stdscripts\meditfunctions.ms
			editMtl = meditUtilities.getDefaultMaterial undefined
			$.material = editMtl
		)

		-- Close Medit
		maxOps.mtlDlgMode = #advanced  -- closes Medit if open and switches to SME

		-- Open SME, or restore the window if minimized
		sme.Open() -- checking sme.IsOpen() is not reliable, it returns true if window is minimized
		
		local nodeViewIndex = sme.activeView
		local nodeView = sme.getView nodeViewIndex
		local nodePos = [0,0]
		nodeView.CreateNode editMtl nodePos
		nodeView.setSelectedNodes #(editMtl)
		nodeView.zoomExtents type:#selected

		sme.SetMtlInParamEditor editMtl
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA/xccqL0ppTBI+Z58i8DDZv7zzXixo0+5e
-- i531K/zBWU2eUJz7Z+r+4xc91QQ2ipgHDNdwuG7wnaFnry8gqs2a4T7wq7QIn40Q
-- 3hu6lkkQbl20RydD7EwvMcJZNAbk4gDmAmH+FBc9taGQBcylfSPDMaoJl4NWUUDz
-- qBTLlsTefrU8YN5ry0W3P0ONPLbg60Rnoox9ahEd6Q3Hj/HBKrbIoIZHInAjYLUi
-- JSx7D5TeoE0wA+vIot3G6DdocPa0AZc8DY7PbW4RC/3/qT0UkTeZBJRk0MoZ/F+e
-- OgbOjINH0IxwjDgctG1FiTZgOIWFL8/RI0X6y7cmAyr7yE5fbUlc
-- -----END-SIGNATURE-----